<?php

namespace Modules\Frontend\Livewire\Form;

use Livewire\Component;
use Modules\Map\app\Models\CheckInOut;

class Checkin extends Component
{
    public $showCheckinForm = false;
    public $work_time = false;
    public $drive_car = false;
    public $place_name = '';
    public $lat = '';
    public $lng = '';
    public $address = '';
    public $currentPlace = '';
    public $targetPlace = '';
    public $reason = '';
    public $checkinTime = '';
    public $member = [],$type = '';

    public function mount($member)
    {
        $this->member = $member;
    }

    public function render()
    {
        return view('frontend::livewire.form.checkin');
    }

    public function saveCheckin()
    {
        $this->showCheckinForm = true;
        $this->validate([
            'place_name' => 'required|string',
            'lat' => 'required|numeric',
            'lng' => 'required|numeric',
            'address' => 'required|string',
            'currentPlace' => 'required|string',
            'targetPlace' => 'required|string',
            'reason' => 'required|string',
        ], [
            'place_name.required' => 'กรุณาเลือกชื่อสถานที่',
            'lat.required' => 'กรุณาอนุญาตการเข้าถึงตำแหน่ง',
            'lng.required' => 'กรุณาอนุญาตการเข้าถึงตำแหน่ง',
            'address.required' => 'ไม่พบข้อมูลที่อยู่',
            'currentPlace.required' => 'กรุณากรอกชื่อสถานที่ปัจจุบัน',
            'targetPlace.required' => 'กรุณากรอกชื่อสถานที่จะไป',
            'reason.required' => 'กรุณากรอกเหตุผล',
        ]);

        // ตรวจสอบว่าต้องเลือก checkbox อย่างน้อย 1 รายการ
        if (!$this->work_time && !$this->drive_car) {
            $this->addError('checkbox_status', 'กรุณาเลือกสถานะอย่างน้อย 1 รายการ (ลงเวลาทำงาน หรือ ขับรถ)');
            return;
        }

        $attr = [
            'member_id' => auth()->guard('member')->user()->id,
            'place' => $this->place_name,
            'lat' => $this->lat,
            'lng' => $this->lng,
            'time' => now(),
            'address' => $this->address,
            'distance_km' => 0,
            'current_place' => $this->currentPlace,
            'target_place' => $this->targetPlace,
            'reason' => $this->reason,
            'status_request' => json_encode(['drive_car' => $this->drive_car, 'work_time' => $this->work_time]),
            'status' => 1,
        ];
        $checkin = CheckInOut::create($attr);
        // กำหนดอายุ session checkin_id เป็น 24 ชั่วโมง (1440 นาที)
        session()->put('checkin_id', $checkin->id);
        session()->put('checkin_id_expires_at', now()->addHours(24));
        return redirect()->route('frontend.checkout_map');
    }

    public function showCheckinForm()
    {
        $this->showCheckinForm = true;
    }
}
