# คู่มือการติดตั้งระบบ Login - Quick Start

## 🚀 ขั้นตอนการติดตั้ง (5 นาที)

### 1. รัน Migration
```bash
php artisan migrate
```

### 2. สร้างข้อมูลทดสอบ
```bash
php artisan db:seed --class=UserSeeder
```

### 3. ทดสอบ Login
- เปิดเบราว์เซอร์ไปที่: `http://localhost/login`
- ใช้ข้อมูล:
  - **รหัสพนักงาน**: `EMP001`
  - **รหัสผ่าน**: `1234`

---

## 🎯 ผู้ใช้ทดสอบ

| รหัสพนักงาน | รหัสผ่าน | บทบาท | หมายเหตุ |
|------------|---------|--------|----------|
| EMP001 | 1234 | employee | ใช้งานได้ปกติ |
| EMP002 | 1234 | manager | ผู้จัดการ → redirect ไป `/recorddatamanager` |
| EMP003 | 1234 | employee | ❌ บัญชีถูกปิด (ทดสอบ error) |
| ADMIN | admin123 | admin | ผู้ดูแลระบบ |

---

## 📁 ไฟล์ที่สำคัญ

### Components
- `Modules/Frontend/Livewire/LoginForm.php` - Logic การ Login
- `Modules/Frontend/Livewire/LogoutButton.php` - Logic การ Logout

### Views
- `Modules/Frontend/resources/views/login.blade.php` - หน้า Login
- `Modules/Frontend/resources/views/livewire/login-form.blade.php` - Livewire Form
- `Modules/Frontend/resources/views/livewire/logout-button.blade.php` - ปุ่ม Logout

### CSS
- `public/assets/frontend/css/login.css` - สไตล์หน้า Login

### Database
- `database/migrations/2025_10_24_101002_add_employee_fields_to_users_table.php`
- `database/seeders/UserSeeder.php`

---

## 🔧 ตัวอย่างการใช้งาน

### ใส่ Login Form
```blade
@livewire('frontend::login-form')
```

### ใส่ปุ่ม Logout (ในหน้าที่ต้อง Login)
```blade
@livewire('frontend::logout-button')
```

### ป้องกันหน้าด้วย Middleware
```php
// routes/web.php

// หน้าที่ต้อง Login ก่อนถึงเข้าได้
Route::get('/recorddata', [FrontendController::class, 'recorddata'])
    ->name('frontend.recorddata')
    ->middleware('auth');

// ป้องกันไม่ให้คนที่ Login แล้วเข้าหน้า Login
Route::get('/login', [FrontendController::class, 'login'])
    ->name('frontend.login')
    ->middleware('guest');
```

### ดึงข้อมูล User ที่ Login
```php
// ใน Controller หรือ View
$user = Auth::user();
$empCode = Auth::user()->emp_code;
$userName = Auth::user()->name;
$role = Auth::user()->role;
```

---

## ✅ เช็คว่าระบบทำงานหรือไม่

1. ✅ สามารถเปิดหน้า Login ได้
2. ✅ Login ด้วย EMP001/1234 สำเร็จ
3. ✅ ถูก redirect ไปหน้า `/recorddata`
4. ✅ แสดงข้อความ error เมื่อรหัสผ่านผิด
5. ✅ แสดงข้อความ error เมื่อบัญชีถูกปิด (EMP003)
6. ✅ ปุ่ม Logout ทำงาน และกลับไปหน้า Login

---

## 🐛 แก้ปัญหาเบื้องต้น

### ปัญหา: หน้า Login ไม่แสดงผล
```bash
php artisan cache:clear
php artisan config:clear
php artisan view:clear
```

### ปัญหา: CSS ไม่โหลด
- เช็คว่าไฟล์อยู่ที่ `public/assets/frontend/css/login.css`
- Refresh (Ctrl+F5) บนเบราว์เซอร์

### ปัญหา: Livewire ไม่ทำงาน
- เช็คว่ามี `@livewireStyles` ใน `<head>`
- เช็คว่ามี `@livewireScripts` ก่อน `</body>`
- เช็ค Browser Console สำหรับ JavaScript errors

---

## 📚 เอกสารเพิ่มเติม

อ่านเอกสารฉบับเต็ม: `Modules/Frontend/LIVEWIRE_LOGIN_README.md`

---

**สร้างเมื่อ:** 24 ตุลาคม 2025  
**เวอร์ชัน:** 1.0.0

