import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';

export default defineConfig({
	build: {
		outDir: '../../public/build-content',
		emptyOutDir: true,
		manifest: true,
	},
	plugins: [
		laravel({
			publicDirectory: '../../public',
			buildDirectory: 'build-content',
			input: [
				__dirname + '/resources/assets/sass/app.scss',
				__dirname + '/resources/assets/js/category.js',
				__dirname + '/resources/assets/js/content.js',
				__dirname + '/resources/assets/js/page.js',
			],
			refresh: true,
		}),
	],
});

//export const paths = [
//    'Modules/$STUDLY_NAME$/resources/assets/sass/app.scss',
//    'Modules/$STUDLY_NAME$/resources/assets/js/app.js',
//];