@php
    $setting = $config['form']['sidebar']['setting']['input'];
    $k_last = array_key_last($setting);
@endphp
<div class="card card-body">
    @foreach ($setting as $k_s => $s)
        @if (!empty($s['status']))
            @php
                $chk_req = !empty($s['validate']);
            @endphp
            <div class="{{ $k_s != $k_last && $s['type'] != 'checkbox' ? 'mb-2' : '' }} {{ $k_s }}">
                @if ($s['type'] == 'checkbox')
                    @php
                        $chk = !empty($data) ? $data->{$k_s} == 1 : $k_s == 'status';
                    @endphp
                    <x-form.checkbox name="{{ $k_s }}" label='{{ __("field.{$k_s}") }}' :checked=$chk />
                @elseif (in_array($s['type'],['input','tel','email']))
                    <x-form.input name="{{ $k_s }}" type='{{ $s["type"] ?? "text" }}' value="{{ $data->{$k_s} ?? null }}" label='{{ __("field.{$k_s}") }}' placeholder='{{ __("field.{$k_s}_placeholder") }}' :required=$chk_req />
                @elseif ($s['type'] == 'multiple')
                    @php
                        $selected = $data->{$k_s} ?? null;
                    @endphp
                    <x-select2.multiple id="{{ $k_s }}" name="{{ $k_s }}[]" :selected=$selected label='{{ __("field.{$k_s}") }}' :required=$chk_req url="{{ route($s['url']) }}" placeholder='{{ __("field.{$k_s}_placeholder") }}' />
                @elseif ($s['type'] == 'select')
                    @php
                        $selected = null;
                        if (str_contains($k_s, '_id')) {
                            $new_k_s = str_replace('_id', '', $k_s);
                            $selected = $data->{$new_k_s} ?? null;
                            if (!empty($selected) && empty($selected->parent)) {
                                $selected = null;
                            }
                        } elseif (!empty($data->{$k_s}[0])) {
                            $f = $data->{$k_s}[0];
                            $selected = (object) ['id' => $f->id, 'name' => $f->local->name];
                        }
                        $label = $s['label'] ?? __("field.{$k_s}");
                    @endphp
                    <x-select2.select id="{{ $k_s }}" name="{{ $k_s }}" :selected=$selected  label='{{ $label }}' :required=$chk_req url="{{ route($s['url']) }}" placeholder='{{ __("field.{$k_s}_placeholder") }}' parent="id" />
                    @elseif ($s['type'] == 'selection')
                    @php
                        $chk_option = !empty($data->{$k_s}) ? $data->{$k_s} : 1;
                    @endphp
                    <x-select2.selection class="select2" id="{{ $k_s }}" name="{{ $k_s }}" label='{{ __("field.{$k_s}") }}' placeholder='{{ __("field.{$k_s}_placeholder") }}' :required=$chk_req>
                        <x-slot:option>
                            @if (!empty($s['options']))
                                @foreach ($s['options'] as $k_o => $o)
                                    <option value="{{ $k_o }}" @if ($chk_option == $k_o) selected @endif>
                                        {{ $o }}
                                    </option>
                                @endforeach
                            @endif
                        </x-slot:option>
                    </x-select2.selection>
                    @elseif ($s['type'] == 'icon')
                    <label class="form-label {{ $s['validate'] ? 'required' : '' }}">{{ __("field.{$k_s}") }}</label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="{{ $s['icon'] ?? '' }}"></i>
                        </span>
                        @php
                            $val = !empty($s['start']) && !empty($s['end']) ? str_implode(' to ', $data->{$s['start']} ?? null, $data->{$s['end']} ?? null) : $data->{$k_s} ?? null;
                        @endphp
                        <input class="form-control {{ $s['class'] ?? '' }}" id="{{ $k_s }}" name="{{ $k_s }}" type="text" value="{{ $val }}" placeholder="{{ __("field.{$k_s}_placeholder") }}">
                    </div>
                @elseif ($s['type'] == 'time')
                    <label class="form-label {{ $s['validate'] ? 'required' : '' }}">{{ __("field.{$k_s}") }}</label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="{{ $s['icon'] ?? '' }}"></i>
                        </span>
                        <input class="form-control {{ $s['class'] ?? '' }}" id="{{ $s['start'] }}" name="{{ $s['start'] }}" type="text" value="{{ $data->{$s['start']} ?? '' }}" placeholder="--:--">
                        <span class="input-group-text">-</span>
                        <input class="form-control {{ $s['class'] ?? '' }}" id="{{ $s['end'] }}" name="{{ $s['end'] }}" type="text" value="{{ $data->{$s['end']} ?? '' }}" placeholder="--:--">
                    </div>
                @endif
            </div>
        @endif
    @endforeach
</div>
