window.setSave = function () {
	event.preventDefault();
	tinyMCE.triggerSave();

	if ($_link_save.length > 0) {
		($_config.form.navbar.seo.status) && mwzGenerateMatadata(0);
		$(`#submit`).prop('disabled', true);
		const frm = $(`#${$_name}_frm`);
		const frm_data = new FormData($(frm)[0]);

		$.ajax({
			url: $_link_save,
			type: "POST",
			data: frm_data,
			contentType: false,
			processData: false,
			headers: {
				"X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
			},
			beforeSend: function (xhr) {
				let rules = [], msg = [];

				if ($_config.form.navbar.translate.status) {
					$.each($_lang, function (i, lang) {
						$.each($_config.form.navbar.translate.input, function (k, e) {
							rules[`${k}_${lang}`] = (k != "name") ? { required: e.validate && e.status } : { required: e.validate && e.status, maxlength: 255 };
							msg[`${k}_${lang}`] = { required: $(frm).find(`[name="${k}_${lang}"]`).attr('placeholder') };
						});
					});
				}
				if ($_config.form.sidebar.setting.status) {
					$.each($_config.form.sidebar.setting.input, function (k, e) {
						rules[`${k}`] = { required: e.status && e.validate };
						msg[`${k}`] = { required: $(frm).find(`[name="${k}"]`).attr('placeholder') };
					});
				}

				mwz_validate($(frm), rules, msg);

				if (!frm_valid($(frm))) {
					$(`#submit`).prop('disabled', false);
					return false;
				}

				return true;
			},
			success: function (resp) {
				$(frm).find("#id").val(resp.id);
				($_config.form.navbar.upload.status && $_config.form.navbar.upload.input.gallery.status && $('#gallery').length > 0) ? mwz_multi_upload_process(MULTI_UPLOAD["gallery"], resp) : save_return(resp)
			},
			error: function (xhr, status, thrown) {
				$(`#submit`).prop('disabled', false);
				ajax_error(xhr, status, thrown);
			}
		});
	}
};

window.multiFileUploadCallBack = function (file, resp) {
	save_return(resp);
}

window.save_return = function (resp) {
	mwz_noti("success", resp.msg, window.location.reload());
}