$(document).ready(function () {
	initDatatable();
	($('[name="style"]').length > 0) && $('[name="style"]').change();
	
})

window.initDatatable = function () {
	if ($(`#${$_name}-datatable`).length > 0) {
		let column = [{ data: "DT_RowIndex", className: 'text-center' }];

		$_config.table.header.forEach((e) => {
			if (e.status)
				column.push({ data: e.column, orderable: e.orderable, className: e.class ?? '' });
		});
		($_config.table.btn.sort) && column.push({ data: "sort", orderable: false, className: 'text-center' });
		column.push(
			{ data: "updated_at", orderable: true },
			{ data: "action", orderable: false, className: 'text-center' }
		);

		let cfg = {
			processing: true,
			serverSide: true,
			stateSave: true,
			columnDefs: [
				{ orderable: true, className: "reorder", targets: 0 },
				{ orderable: false, targets: "_all" },
			],
			ajax: {
				url: $_link_datatable,
				data: function (d) {
					($('.frm-filter').length > 0) && $(".frm-filter").serializeArray().map(function (x) {
						(x.name != '_token') && (d[x.name] = x.value);
					});
				}
			},
			columns: column,
			language: $_LANG.datatable,
		};

		const oTable = $(`#${$_name}-datatable`).DataTable(cfg);
		init_Table();
	}
}

window.setReloadDataTable = function (bool = false) {
	($(`#${$_name}-datatable`).length > 0) && $(`#${$_name}-datatable`).DataTable().ajax.reload(null, bool);
}

window.setSort = function (id, move) {
	event.preventDefault();

	if ($_link_sort.length > 0) {
		$.ajax({
			url: $_link_sort,
			type: "POST",
			data: { id: id, move: move },
			headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
			success: function (resp) {
				mwz_noti("success", resp.msg, setReloadDataTable());
			},
			error: function (xhr, status, thrown) {
				ajax_error(xhr, status, thrown);
			}
		});
	};
};

window.setDefault = function (id) {
	event.preventDefault();

	if ($_link_default.length > 0) {
		$.ajax({
			url: $_link_default,
			type: "POST",
			data: { id: id },
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
			success: function (resp) {
				mwz_noti("success", resp.msg, setReloadDataTable());
			},
			error: function (xhr, status, thrown) {
				ajax_error(xhr, status, thrown);
			}
		})
	}
};

window.setStatus = function (id) {
	event.preventDefault();

	if ($_link_status.length > 0) {
		$.ajax({
			url: $_link_status,
			type: "POST",
			data: { id: id },
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
			success: function (resp) {
				mwz_noti("success", resp.msg, setReloadDataTable());
			},
			error: function (xhr, status, thrown) {
				ajax_error(xhr, status, thrown);
			}
		})
	}
};

window.setDelete = function (id) {
	event.preventDefault();

	if ($_link_delete.length > 0) {
		$.ajax({
			url: $_link_delete,
			type: "POST",
			data: { id: id, },
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
			success: function (resp) {
				mwz_noti("success", resp.msg, setReloadDataTable());

				if (resp.limit)
					$(`#add`).removeClass('d-none');
			},
			error: function (xhr, status, thrown) {
				ajax_error(xhr, status, thrown);
			}
		});
	}
};

window.setSave = function () {
	event.preventDefault();
	tinyMCE.triggerSave();

	if ($_link_save.length > 0) {
		($_config.form.navbar.seo.status) && mwzGenerateMatadata(0);
		$(`#submit`).prop('disabled', true);
		const frm = $(`#${$_name}_frm`);
		const frm_data = new FormData($(frm)[0]);

		$.ajax({
			url: $_link_save,
			type: "POST",
			data: frm_data,
			contentType: false,
			processData: false,
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
			beforeSend: function (xhr) {
				let rules = [], msg = [];

				if ($_config.form.navbar.translate.status) {
					$.each($_lang, function (i, lang) {
						$.each($_config.form.navbar.translate.input, function (k, e) {
							rules[`${k}_${lang}`] = (k != "name") ? { required: e.validate && e.status } : { required: e.validate && e.status, maxlength: 255 };
							msg[`${k}_${lang}`] = { required: $(frm).find(`[name="${k}_${lang}"]`).attr('placeholder') };
						});
					});
				}
				if ($_config.form.navbar.other.status) {
					$.each($_config.form.navbar.other.input, function (k, e) {
						rules[`${k}`] = { required: e.status && e.validate };
						msg[`${k}`] = { required: $(frm).find(`[name="${k}"]`).attr('placeholder') };
					});
				}
				if ($_config.form.sidebar.setting.status) {
					$.each($_config.form.sidebar.setting.input, function (k, e) {
						rules[`${k}`] = { required: e.status && e.validate };
						msg[`${k}`] = { required: $(frm).find(`[name="${k}"]`).attr('placeholder') };
					});
				}

				mwz_validate($(frm), rules, msg);

				if (!frm_valid($(frm))) {
					$(`#submit`).prop('disabled', false);
					return false;
				}

				return true;
			},
			success: function (resp) {
				$(frm).find("#id").val(resp.id);
				($_config.form.navbar.upload.status && $_config.form.navbar.upload.input.gallery.status && $('#gallery').length > 0) ? mwz_multi_upload_process(MULTI_UPLOAD["gallery"], resp) : save_return(resp)
			},
			error: function (xhr, status, thrown) {
				$(`#submit`).prop('disabled', false);
				ajax_error(xhr, status, thrown);
			}
		});
	}
};

window.multiFileUploadCallBack = function (file, resp) {
	save_return(resp);
}

window.save_return = function (resp) {
	mwz_noti("success", resp.msg, window.location.replace(resp.url));
}

window.$('[name="style"]').change(function (e) {
	e.preventDefault();
	const id = $(this).val();
	
	($('.link').length > 0) && $('.link')[id == 1 ? 'fadeIn' : 'fadeOut']();
	if ($('.tab-style').length > 0) {
		$('.tab-style').removeClass('active');
		$('.tab-style').each(function () {
			console.log($(this).data('id'));
			($(this).data('id') == id) && $(this).addClass('active');
		})
	}

	init_card();
});