<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Kalnoy\Nestedset\NestedSet;

return new class extends Migration
{
	// /**
	//  * Run the migrations.
	//  */
	public function up(): void
	{
		Schema::create('content_pages', function (Blueprint $table) {
			$table->id();
			$table->tinyText('type')->nullable();
			$table->string('image')->nullable();
			$table->string('video')->nullable();
			$table->string('youtube')->nullable();
			$table->string('file')->nullable();
			$table->text('gallery')->nullable();
			$table->string('link')->nullable();
			$table->tinyInteger('status')->nullable();
			$table->timestamps();
		});

		Schema::create('content_page_translate', function (Blueprint $table) {
			$table->id();
			$table->unsignedBigInteger('page_id')->nullable();
			$table->string('lang')->nullable();
			$table->text('name')->nullable();
			$table->longText('desc')->nullable();
			$table->longText('detail')->nullable();
			$table->longText('text')->nullable();
			$table->text('location')->nullable();
			$table->timestamps();
		});

		Schema::create('contents', function (Blueprint $table) {
			$table->id();
			$table->tinyText('type')->nullable();
			$table->text('gallery')->nullable();
			$table->string('image')->nullable();
			$table->string('video')->nullable();
			$table->string('youtube')->nullable();
			$table->string('file')->nullable();
			$table->timestamp('publish_at')->nullable();
			$table->dateTime('start_at')->nullable();
			$table->dateTime('end_at')->nullable();
			$table->time('start_time')->nullable();
			$table->time('end_time')->nullable();
			$table->string('link')->nullable();
			$table->string('email')->nullable();
			$table->string('phone')->nullable();
			$table->text('gmap')->nullable();
			$table->integer('view')->default(0)->nullable();
			$table->tinyInteger('default')->default(0)->nullable();
			NestedSet::columns($table);
			$table->boolean('status')->default(0)->nullable();
			$table->string('style')->nullable();
			$table->string('extension')->nullable();
			$table->string('color_code')->nullable();
			$table->timestamps();
		});

		Schema::create('content_translate', function (Blueprint $table) {
			$table->id();
			$table->unsignedBigInteger('content_id')->nullable();
			$table->string('lang')->nullable();
			$table->text('name')->nullable();
			$table->longText('desc')->nullable();
			$table->longText('detail')->nullable();
			$table->longText('text')->nullable();
			$table->text('location')->nullable();
			$table->string('prefix')->nullable();
			$table->timestamps();
		});

		Schema::create('content_and_categories', function (Blueprint $table) {
			$table->unsignedBigInteger('content_id')->nullable();
			$table->unsignedBigInteger('category_id')->nullable();
		});

		Schema::create('content_related', function (Blueprint $table) {
			$table->unsignedBigInteger('content_id')->nullable();
			$table->unsignedBigInteger('related_id')->nullable();
		});

		Schema::create('content_categories', function (Blueprint $table) {
			$table->id();
			$table->tinyText('type')->nullable();
			$table->string('image')->nullable();
			$table->boolean('default')->default(0)->nullable();
			NestedSet::columns($table);
			$table->boolean('status')->default(0)->nullable();
			$table->timestamps();
		});

		Schema::create('content_category_translate', function (Blueprint $table) {
			$table->id();
			$table->unsignedBigInteger('category_id')->nullable();
			$table->string('lang')->nullable();
			$table->text('name')->nullable();
			$table->longText('desc')->nullable();
			$table->longText('detail')->nullable();
			$table->timestamps();
		});

		Schema::create('content_view', function (Blueprint $table) {
			$table->id();
			$table->string('type')->nullable();
			$table->string('ip')->nullable();
			$table->unsignedBigInteger('content_id')->nullable();
			$table->string('user_agent')->nullable();
			$table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 */
	public function down(): void
	{
		Schema::dropIfExists('content_pages');
		Schema::dropIfExists('content_page_translate');
		Schema::dropIfExists('contents');
		Schema::dropIfExists('content_translate');
		Schema::dropIfExists('content_and_categories');
		Schema::dropIfExists('content_related');
		Schema::dropIfExists('content_categories');
		Schema::dropIfExists('content_category_translate');
		Schema::dropIfExists('content_view');
	}
};
