<?php

namespace Modules\Content\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Pages extends Model
{
	use HasFactory;

	/**
	 * The attributes that are mass assignable.
	 */
	protected $fillable = [
		'type',
		'image',
		'video',
		'youtube',
		'file',
		'gallery',
		'link',
		'status',
	];
	protected $table = 'content_pages';
	protected $primaryKey = 'id';

	protected static function boot(): void
	{
		parent::boot();
		static::deleting(function ($model) {
			$model->langs()->delete();
		});
	}

	public function langs()
	{
		return $this->hasMany(PageTranslate::class, 'page_id', 'id');
	}

	public function local()
	{
		return $this->hasOne(PageTranslate::class, 'page_id', 'id')->where('lang', app()->getLocale() ?? config('app.fallback_locale'));
	}

	public function default()
	{
		return $this->hasOne(PageTranslate::class, 'page_id', 'id')->where('lang', config('app.fallback_locale'));
	}
}
