<?php

namespace Modules\Content\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ContentTranslate extends Model
{
	use HasFactory;

	/**
	 * The attributes that are mass assignable.
	 */
	protected $fillable = [
		'content_id',
		'lang',
		'name',
		'desc',
		'detail',
		'text',
		'location',
		'prefix',
	];
	protected $table = 'content_translate';
	protected $primaryKey = 'id';

	public function content()
	{
		return $this->hasOne(Contents::class, 'id', 'content_id');
	}
}
