<?php

namespace Modules\Content\app\Http\Controllers;

use Illuminate\Http\Response;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Storage;
use Modules\Content\app\Models\Pages;
use Modules\Mwz\app\Http\Controllers\AdminController;
use Modules\Mwz\app\Http\Controllers\SlugController;

class ContentPageAdminController extends AdminController
{
	private $module, $method, $action, $config;

	/**
	 * Function : construct
	 * Dev : Petch
	 * Update Date : 22 Jan 2025
	 */
	public function __construct()
	{
		$routeName = Route::currentRouteName();
		if ($routeName) {
			$explode = explode('.', $routeName);
			$this->module = $explode[1] ?? '';
			$this->method = $explode[2] ?? '';
			$this->action = $explode[3] ?? '';
		} else {
			$this->module = '';
			$this->method = '';
			$this->action = '';
		}

		self::$navbar = [
			['name' => __("content::page.{$this->module}.title"), 'url' => null],
			['name' => __("content::page.{$this->module}.name"), 'url' => route_has("admin.{$this->module}.page.index")]
		];

		$this->config = config("content.page.{$this->module}");
	}

	/**
	 * Function : index
	 * Dev : Petch
	 * Update Date : 22 Jan 2025
	 */
	public function index()
	{
		$meta = self::set_metadata($this->module, $this->module, 1);

		$data = Pages::where('type', $this->module)->first();
		if (!empty($data->langs)) {
			$data->langs = $data->langs->groupBy('lang')->map(function ($row) {
				return  $row->first();
			});
		}

		if (!empty($this->config['form']['navbar']['seo']['status']))
			$meta = array_merge($meta, SlugController::getMetadata($this->module, $this->module, 1));

		return view('content::page.form', [
			'config' => $this->config,
			'navbar' => self::$navbar,
			'type' => $this->module,
			'method' => $this->method,
			'action' => $this->action,
			'data' => $data,
			'meta' => $meta,
		]);
	}

	/**
	 * Function : save
	 * Dev : Petch
	 * Update Date : 22 Jan 2025
	 */
	public function save(Request $request)
	{
		$rule = $msg = [];
		$navbar = $this->config['form']['navbar'];
		$sidebar = $this->config['form']['sidebar'];
		if (!empty($navbar['translate']['status'])) {
			foreach (languages() as $lang => $l) {
				foreach ($navbar['translate']['input'] as $k => $i) {
					if (!empty($i['status']) && !empty($i['validate'])) {
						$rule["{$k}_{$lang}"] = ($k != 'name') ? 'required' : 'required|max:255';
						$msg["{$k}_{$lang}.*"] = __("field.{$k}_placeholder") . ' ' . ($l['name'] ?? '');
					}
				}
			}
		}
		foreach ($sidebar as $s) {
			if (empty($s['status']) || empty($s['input']))
				continue;

			foreach ($s['input'] as $k => $i) {
				if (!empty($i['status']) && !empty($i['validate'])) {
					$rule["{$k}"] = 'required';
					$msg["{$k}.*"] = __("field.{$k}_placeholder");
				}
			}
		}
		//validate post data
		$valid = validator($request->all(), $rule, $msg);
		if ($valid->fails())
			return self::response(['msg' => $valid->errors()->first(), 'error' => $valid->errors()], Response::HTTP_BAD_REQUEST);

		$attr = [];
		foreach ($sidebar as $s) {
			if (empty($s['status']) || empty($s['input']))
				continue;

			foreach ($s['input'] as $k => $i) {
				if (empty($i['status']))
					continue;

				$attr[$k] = $k == 'status' ? ($request->get($k) ?? 0) : $request->get($k);
			}
		}
		if (!empty($navbar['upload']['status'])) {
			foreach ($navbar['upload']['input'] as $k_u => $u) {
				if ($u['type'] == 'gallery' || empty($u['status']))
					continue;

				if ($k_u == 'youtube' && !empty($request->get('youtube')))
					$attr['youtube'] = self::embed($request->get("youtube"));
				elseif (str_contains($u['type'], 'upload_')) {
					$chk = $this->save_upload($request, $k_u, str_replace('upload_', '', $u['type']));
					if (!$chk['status'])
						return self::response(['msg' => ($s_b['label'] ?? '') . ' ' . $chk['msg']], Response::HTTP_NOT_ACCEPTABLE);
					$attr[$k_u] = $chk['result'];
				} else
					$attr[$k_u] = $request->get($k_u);
			}
		}

		$set = Pages::updateOrCreate(['type' => $this->module], $attr);
		if ($set->save()) {
			if (!empty($navbar['translate']['status']))
				self::setLangs($request, $set, $navbar['translate']['input']);

			if (!empty($navbar['seo']['status']))
				SlugController::createMetadata($request, $set->id);

			if (!empty($navbar['upload']['status']) && !empty($navbar['upload']['input']['gallery']['status'])) {
				$request->merge(['id' => $set->id]);
				self::save_gallery($request);
			}


			return self::response(['msg' => __('noti.success'), 'id' => $set->id]);
		}
		return self::response(['msg' => __('noti.error')], Response::HTTP_INTERNAL_SERVER_ERROR);
	}

	/**
	 * Function : set translate
	 * Dev : Petch
	 * Update Date : 22 Jan 2025
	 */
	private function save_upload($request, $name, $type)
	{
		if (check_file_upload($request, $name, $type))
			return ['status' => false, 'msg' => __('noti.mime_image')];

		return ['status' => true, 'result' => self::set_image_upload($request, $name, "public/{$this->module}", "{$type}-")];
	}

	/**
	 * Function : set translate
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	private function setLangs(Request $request, $row, $config)
	{
		foreach (array_keys(languages()) as $lang) {
			$attr = [];
			foreach ($config as $key => $item)
				$attr[$key] = !empty($request->get("{$key}_{$lang}")) ? mwz_setTextString($request->get("{$key}_{$lang}"), $item['type'] == 'texteditor') : null;

			$row->langs()->updateOrCreate(['lang' => $lang], $attr);
		}
	}

	/**
	 * Function : save gallery
	 * Dev : Petch
	 * Update Date : 22 Jan 2025
	 */
	public function save_gallery(Request $request)
	{
		if (!empty($request->get('id'))) {
			$field_name = 'gallery';
			$upload_path = "/storage/{$this->module}/gallery";
			$images = $remove = [];
			// remove file if has
			if (!empty($request->get('id'))) {
				// delete file from multiple
				if ($request->get("{$field_name}_file_removed") != '') {
					$remove_list = json_decode($request->get("{$field_name}_file_removed"));
					if (!empty($remove_list)) {
						foreach ($remove_list as $rm_file) {
							$remove[] = $rm_file;
							$remove_file = str_replace('/storage', '', $rm_file);
							if (Storage::disk('public')->exists($remove_file))
								Storage::disk('public')->delete($remove_file);
						}
					}
				}
			}
			// upload file multiple
			$uploaded = [];
			if ($request->hasFile($field_name)) {
				foreach ($request->file($field_name) as $file) {
					if ($file->getClientMimeType() !== $file->getMimeType() || !in_array($file->getClientMimeType(), mime_type(['image', 'video'])))
						continue;

					$new_filename = str_replace(' ', '', $file->getClientOriginalName());
					$file->move(public_path($upload_path), $new_filename);
					$uploaded[] = $upload_path . '/' . $new_filename;
				}
			}

			// set image json 
			$index = 0;
			$file_lists = json_decode($request->get("{$field_name}_file_list"), 1);
			if (!empty($file_lists)) {
				foreach ($file_lists as $fl) {
					if ($fl['complete'] == false) {
						$image = $uploaded[$index++] ?? '';
						if (empty($image))
							continue;

						$fl['image'] =  $image;
						$fl['complete'] = true;
						$images[] = $fl;
					} elseif (!in_array($fl['image'], $remove))
						$images[] = $fl;
				}
			}

			$set = Pages::updateOrCreate(['type' => $this->module], ['gallery' => !empty($images) ? json_encode($images, JSON_UNESCAPED_UNICODE) : null]);
			if ($set->save())
				return self::response(['msg' => __('noti.success'), 'id' => $set->id]);

			return self::response(['msg' => __('noti.error'), 'id' => $request->get('id')], Response::HTTP_INTERNAL_SERVER_ERROR);
		}

		return self::response(['msg' => __('noti.error')], Response::HTTP_INTERNAL_SERVER_ERROR);
	}
}
