<?php

namespace Modules\Content\app\Http\Controllers;

use Modules\Content\app\Models\ContentCategories;
use Modules\Mwz\app\Http\Controllers\AdminController;
use Modules\Mwz\app\Http\Controllers\SlugController;

class ContentCategoryController extends AdminController
{
	/**
	 * Function : get list
	 * Dev : Petch
	 * Update Date : 4 March 2025
	 */
	public static function get_list($type, $option = [])
	{
		$data = [];
		$config = config("content.category.{$type}");
		$navbar_c = $config['form']['navbar'];
		$sidebar_c = $config['form']['sidebar'];
		$per_page = $all = 0;

		$query = ContentCategories::where([['type', $type], ['status', 1]]);

		if (!empty($option['id']))
			$query = $query->where('id', $option['id']);

		if (!empty($option['parent'])) {
			$parent = ContentCategories::where('type', $type)->whereNull('parent_id')->first();
			if (!empty($parent))
				$query = $query->where('parent_id', $parent->id);
		}
		if (!empty($option['default']))
			$query = $query->where('default', 1);

		if (!empty($option['per_page']) && $option['per_page']) {
			$data['cur_page'] = $option['cur_page'] ?? 1;
			$per_page =  intval($option['per_page']);

			$all = $query->count();
			$offset = ($data['cur_page'] - 1) * $per_page;

			if (!empty($option['skip'])) {
				$offset += $option['skip'];
				$all -= $option['skip'];
				$all = $all < 0 ? 0 : $all;
			}

			$data['total'] = (int) ceil((int)$all / $per_page);
			$query = $query->limit($per_page)->offset($offset);
		} elseif (!empty($option['limit']))
			$query = $query->limit($option['limit']);

		$catgories = $query->orderBy($option['column'] ?? '_lft', $option['dir'] ?? 'ASC')
			->with(['local'])
			->get();

		foreach ($catgories as $item)
			$data['list'][] = self::mapping($item, $navbar_c, $sidebar_c);

		return $data;
	}

	/**
	 * Function : mapping
	 * Dev : Petch
	 * Update Date : 4 March 2025
	 */
	private static function mapping($param, $navbar, $sidebar)
	{
		$data = [
			'id' => $param->id,
		];

		foreach ($navbar as $k => $v) {
			if (empty($v['status']))
				continue;

			if ($k == 'seo')
				$data['url'] = SlugController::getRoute($param->type, "{$param->type}_category", $param->id) ?? '';
			else {
				foreach ($v['input'] as $k_i => $i) {
					if (empty($i['status']))
						continue;

					if ($k == 'translate')
						$data[$k_i] = mwz_getTextString($param->local->{$k_i} ?? '', $i['type'] == 'texteditor');
					elseif (str_contains($i['type'], 'upload_'))
						$data[$k_i] = check_file($param->{$k_i} ?? '');
					else
						$data[$k_i] = $param->{$k_i} ?? '';
				}
			}
		}

		foreach ($sidebar as $k => $v) {
			if (empty($v['status']) || $k == 'lang')
				continue;

			foreach ($v['input'] as $k_i => $i) {
				if (empty($i['status']))
					continue;

				if ($k_i  == 'parent_id') {
					foreach ($param->child as $c)
						$data['sub'][] = self::mapping($c, $navbar, $sidebar);
				} else
					$data[$k_i] = $param->{$k_i} ?? '';
			}
		}

		return $data;
	}
}
