@extends('form.app')

@section('styles')
@endsection

@section('content')
    {{-- navbar --}}
    @includeIf('contact::subject.form.navbar')

    <?php $input = $config['input']; ?>

    <form class="row" id="subject_frm" method="POST" enctype="multipart/form-data">
        @csrf
        <input id="id" name="id" type="hidden" value="{{ $data->id ?? '0' }}">
        <div class="col-lg-9">
            <div class="tab-content">
                <div class="tab-pane active" id="info">
                    @includeIf('contact::subject.form.translates')
                </div>
                <div class="tab-pane" id="upload">
                    @includeIf('contact::subject.form.upload')
                </div>
                @if (!empty($config['seo']))
                    <div class="tab-pane" id="meta">
                        @includeIf('mwz::seo.form')
                    </div>
                @endif
            </div>
        </div>
        <div class="col-lg-3">
            <x-form.lang />
            @includeIf('contact::subject.form.status')
        </div>
    </form>
@endsection

@section('scripts')
    <script>
        var $_config = $.parseJSON('<?= json_encode($config) ?>');
    </script>
    {{ module_vite('build-contact', 'resources/assets/js/subject.js') }}
@endsection
