@extends('form.app')

@section('styles')
@endsection

@section('content')
    {{-- navbar --}}
    @includeIf('contact::branch.form.navbar')
    <?php $input = $config['input']; ?>
    <?php $contact = $config['contact']; ?>
    <form class="row" id="branch_frm" method="POST" enctype="multipart/form-data">
        @csrf
        <input id="id" name="id" type="hidden" value="{{ $data->id ?? '0' }}">
        <div class="col-lg-9">
            <div class="tab-content">
                <div class="tab-pane active" id="info">
                    @includeIf('contact::branch.form.translates')
                </div>
                <div class="tab-pane" id="contact">
                    @includeIf('contact::branch.form.contact')
                </div>
                @if (!empty($config['upload']['status']))
                    <div class="tab-pane" id="upload">
                        @includeIf('contact::branch.form.upload')
                    </div>
                @endif
                @if (!empty($config['seo']))
                    <div class="tab-pane" id="meta"> @includeIf('mwz::seo.form')</div>
                @endif
            </div>
        </div>

        <div class="col-lg-3">
            <x-form.lang />
            @includeIf('contact::branch.form.status')
        </div>
    </form>
@endsection

@section('scripts')
    <script>
        var $_config = $.parseJSON('<?= json_encode($config) ?>');
        const $_type = '<?= $type ?>';
        const $_module = '<?= $module ?>';

         // link action
         const $_link_save = '{{ route("admin.{$module}.{$type}.save") }}';
    </script>
    {{ module_vite('build-contact', 'resources/assets/js/branch.js') }}
@endsection
