
$(document).ready(function () {
	initDatatable()
})
/**
* Function : Init Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.initDatatable = function () {
	if ($("#list-datatable").length > 0) {
		var column = [
			{ data: "DT_RowIndex", className: 'text-center' },
			{ data: "name", orderable: true },
		];

		($_config.company) && column.push({ data: "company", orderable: true });
		($_config.email || $_config.tel) && column.push({ data: "contact", orderable: true });
		($_config.line) && column.push({ data: "line_id", orderable: true });
		($_config.subject) && column.push({ data: "subject", orderable: true });
		column.push(
			{ data: "created_at", },
			{ data: "action", orderable: false, className: 'text-center' });
		$("#list-datatable").DataTable({
			processing: true,
			serverSide: true,
			stateSave: true,
			ajax: {
				url: "/admin/contact/list/datatable_ajax",
				data: function (d) {
					($('.frm-filter').length > 0) && $(".frm-filter").serializeArray().map(function (x) {
						(x.name != '_token') && (d[x.name] = x.value);
					});
				}
			},
			columns: column,
			language: $_LANG.datatable,
		});
		init_Table();
	}
}
/**
* Function : Reload Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setReloadDataTable = function (bool = false) {
	($("#list-datatable").length > 0) &&
		$("#list-datatable").DataTable().ajax.reload(null, bool);
}
/**
* Function : Delete data by id
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setDelete = function (id) {
	event.preventDefault();
	$.ajax({
		url: '/admin/contact/list/set_delete',
		type: "POST",
		data: { id: id, },
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		success: function (resp) {
			mwz_noti("success", resp.msg, setReloadDataTable());
		},
		error: function (xhr, status, thrown) {
			ajax_error(xhr, status, thrown);
		}
	});
};
/**
* Function : Filter Export
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.filterExport = function () {
	($('.filter-export').length > 0) &&
		$('.filter-export').submit();
}