/**
* Function : Set Save
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setSave = function () {
    event.preventDefault();
    tinyMCE.triggerSave();

    ($_config.seo) && mwzGenerateMatadata(0)

    var frm = $("#contact_frm");
    var frm_data = new FormData($(frm)[0]);

    $(`#submit`).prop('disabled', true);

    $.ajax({
        url: '/admin/contact/info/save',
        type: "POST",
        data: frm_data,
        contentType: false,
        processData: false,
        headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
        },
        beforeSend: function (xhr) {
            var rules = [], msg = [];

            // Validate translation fields
            $.each($_config.input, function (key, ele) {
                $.each($_lang, function (i, lang) {
                    rules[`${key}_${lang}`] = { required: ele.validate && ele.status, maxlength: 255 };
                    msg[`${key}_${lang}`] = {
                        required: "This field is required",
                        maxlength: "This field must not exceed 255 characters"
                    };
                });
            });

            // Validate contact fields
            $.each($_config.contact, function (key, ele) {
                rules[key] = { required: ele.validate && ele.status , maxlength: ele.maxlength };
                msg[key] = { required: "This field is required" , maxlength: "This field must not exceed " + ele.maxlength + " characters" };
            });

            mwz_validate($(frm), rules, msg);

            if (!frm_valid($(frm))) {
                $(`#submit`).prop('disabled', false);
                return false;
            }

            return isValidUrl($(frm), $_config.social);
        },
        success: function (resp) {
            mwz_noti("success", resp.msg);
            setTimeout(function () {
                window.location.reload();
            }, 2000); // รอ 2 วินาทีให้ toast โผล่ก่อน
           
        },
        error: function (xhr, status, thrown) {
            $(`#submit`).prop('disabled', false);
            ajax_error(xhr, status, thrown);
        }
    });
};


window.isValidUrl = function (frm, social) {
    var invalidLinks = []; // reset array before usage

    $.each(social, function (i, field) {
        if (field.status) {
            var val = frm.find(`[name="social[${i}][url]"]`).val().trim(); // trim to remove spaces
            console.log(i, val);

            // เช็คว่า val มีค่าและไม่ได้เริ่มต้นด้วย http:// หรือ https://
            if (val && !/^(http:\/\/|https:\/\/)/i.test(val)) {
                invalidLinks.push(i); // เก็บคีย์ของ social ที่ไม่ถูกต้อง
            }
        }
    });

    if (invalidLinks.length > 0) {
        var msg = "Please enter http:// or https://";
        mwz_noti("error", msg);
        return false;
    }

    return true;
}