<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
	// /**
	//  * Run the migrations.
	//  */
	public function up(): void
	{
		Schema::create('contact_info', function (Blueprint $table) {
			$table->id();
			$table->string('image')->nullable();
			// contact
			$table->string('email')->nullable();
			$table->string('tel')->nullable();
			$table->text('google_map')->nullable();
			// social
			$table->longText('social')->nullable();
			$table->timestamps();
		});
		Schema::create('contact_info_translate', function (Blueprint $table) {
			$table->id();
			$table->unsignedBigInteger('info_id')->nullable();
			$table->string('lang')->nullable();
			$table->string('name')->nullable();
			$table->text('desc')->nullable();
			$table->text('detail')->nullable();
			$table->text('work')->nullable();
			$table->text('office')->nullable();
			$table->timestamps();
			$table->foreign('info_id')->references('id')->on('contact_info');
		});

		Schema::create('contact_list', function (Blueprint $table) {
			$table->id();
			$table->string('name')->nullable();
			$table->string('email')->nullable();
			$table->string('tel', 20)->nullable();
			$table->string('subject')->nullable();
			$table->text('msg')->nullable();
			$table->integer('accept')->nullable();
			$table->timestamps();
		});
		Schema::create('subjects', function (Blueprint $table) {
			$table->id();
			$table->string('image')->nullable();
			$table->string('name')->nullable();
			$table->text('desc')->nullable();
			$table->text('detail')->nullable();
			$table->integer('sequence')->nullable();
			$table->integer('status')->nullable();
			$table->timestamps();
		});
		Schema::create('subject_translate', function (Blueprint $table) {
			$table->id();
			$table->unsignedBigInteger('subject_id')->nullable();
			$table->string('lang')->nullable();
			$table->string('name')->nullable();
			$table->text('desc')->nullable();
			$table->text('detail')->nullable();
			$table->timestamps();
			$table->foreign('subject_id')->references('id')->on('subjects');
		});
		Schema::create('branchs', function (Blueprint $table) {
		    $table->id();
			$table->string('type')->nullable();
		    $table->string('image')->nullable();
		    $table->string('name')->nullable();
		    $table->text('desc')->nullable();
		    $table->text('detail')->nullable();
		    $table->text('work')->nullable();
		    $table->text('office')->nullable();
		    // contact
		    $table->string('email')->nullable();
		    $table->string('tel')->nullable();
		    $table->text('google_map')->nullable();
		    // social
		    $table->longText('social')->nullable();
		    // status
		    $table->integer('sequence')->nullable();
		    $table->integer('status')->nullable();
		    $table->timestamps();
		});
		Schema::create('branch_translate', function (Blueprint $table) {
		    $table->id();
		    $table->unsignedBigInteger('branch_id')->nullable();
		    $table->string('lang')->nullable();
		    $table->string('name')->nullable();
		    $table->text('desc')->nullable();
		    $table->text('detail')->nullable();
		    $table->text('work')->nullable();
		    $table->text('office')->nullable();
		    $table->timestamps();
		    $table->foreign('branch_id')->references('id')->on('branchs');
		});
		Schema::create('subscribes', function (Blueprint $table) {
		    $table->id();
		    $table->string('email')->nullable();
		    $table->softDeletesTz();
		    $table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 */
	public function down(): void
	{
		Schema::dropIfExists('contact_info_translate');
		Schema::dropIfExists('contact_info');
		Schema::dropIfExists('contact_list');
		Schema::dropIfExists('subject_translate');
		Schema::dropIfExists('subjects');
		Schema::dropIfExists('branch_translate');
		Schema::dropIfExists('branchs');
		Schema::dropIfExists('subscribes');
	}
};
