<?php

namespace Modules\Contact\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Contact\database\factories\ContactInfoTranslateFactory;

class ContactInfoTranslate extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = ['id', 'info_id', 'lang', 'name', 'desc', 'detail', 'work', 'office', 'created_at', 'updated_at'];
    protected $table = "contact_info_translate";
    protected $primaryKey = "id";
    
    protected static function newFactory(): ContactInfoTranslateFactory
    {
        return ContactInfoTranslateFactory::new();
    }
}
