<?php

namespace Modules\Contact\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ContactInfo extends Model
{
	use HasFactory;

	/**
	 * The attributes that are mass assignable.
	 */
	protected $fillable = [
		'id',
		'image',
		'email',
		'tel',
		'google_map',
		'social',
		'created_at',
		'updated_at'
	];
	protected $table = 'contact_info';
	protected $primaryKey = 'id';

	protected static function boot(): void
	{
		parent::boot();
		static::deleting(function ($model) {
			$model->langs()->delete();
		});
	}

	public function langs()
	{
		return $this->hasMany(ContactInfoTranslate::class, 'info_id', 'id');
	}

	public function local()
	{
		return $this->hasOne(ContactInfoTranslate::class, 'info_id', 'id')->where('lang', app()->getLocale() ?? config('app.fallback_locale'));
	}

	public function default()
	{
		return $this->hasOne(ContactInfoTranslate::class, 'info_id', 'id')->where('lang', config('app.fallback_locale'));
	}
}
