<?php

namespace Modules\Contact\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Contact\Database\factories\BranchsFactory;

class Branchs extends Model
{
    use HasFactory;

    protected $fillable = ['id', 'type', 'image', 'email', 'tel', 'google_map', 'facebook', 'page', 'group', 'line', 'youtube', 'instagram', 'tiktok', 'twitter', 'linkedin', 'google', 'sequence', 'status', 'created_at', 'updated_at'];
    protected $table = "branchs";
    protected $primaryKey = "id";

    protected static function newFactory(): BranchsFactory
    {
        return BranchsFactory::new();
    }
    protected static function boot(): void
    {
        parent::boot();
        static::deleting(function ($model) {
            $model->langs()->delete();
        });
    }
    public function langs()
    {
        return $this->hasMany(BranchTranslate::class, 'branch_id', 'id');
    }
    public function local()
    {
        return $this->hasOne(BranchTranslate::class, 'branch_id', 'id')->where('lang', app()->getLocale() ?? config('app.fallback_locale'));
    }
    public function default()
    {
        return $this->hasOne(BranchTranslate::class, 'branch_id', 'id')->where('lang', config('app.fallback_locale'));
    }
}
