<?php

namespace Modules\Contact\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Contact\Database\factories\BranchTranslateFactory;

class BranchTranslate extends Model
{
    use HasFactory;

    protected $fillable = ['id', 'branch_id', 'lang', 'name', 'desc', 'detail', 'work', 'office', 'created_at', 'updated_at'];
    protected $table = "branch_translate";
    protected $primaryKey = "id";
    
    protected static function newFactory(): BranchTranslateFactory
    {
        return BranchTranslateFactory::new();
    }
}
