<?php

namespace Modules\Contact\app\Http\Controllers;

use App\Http\Controllers\Controller;
use Modules\Contact\app\Models\ContactInfo;

class ContactController extends Controller
{
	/**
	 * Function : contact info
	 * Dev : Petch
	 * Update Date : 5 March 2025
	 */
	public static function contact()
	{
		$config = config('contact.info');
		$data = [];
		$req = ContactInfo::find(1);
		if (!empty($req)) {
			if (!empty($config['upload']['image']))
				$data['image'] = $req->image ?? '';

			foreach ($config['input'] as $key => $item) {
				if (in_array($key, ['name', 'desc', 'detail', 'work', 'office']) && !empty($item['status']))
					$data[$key] = mwz_getTextString($req->local->{$key} ?? null);
				elseif (!empty($item['status']))
					$data[$key] = $req->{$key == 'gmap' ? 'google_map' : $key} ?? null;
			}

			$social = json_decode($req->social, 1);
			foreach ($config['social'] as $key => $item) {
				if ($item['status'] && !empty($social[$key]['url']))
					$data['social'][$key] = $social[$key] ?? '';
			}

			foreach ($config['contact'] as $key => $item) {
				if ($item['status'])
					$data[$key] = $req->{$key == 'gmap' ? 'google_map' : $key} ?? '';
			}
		}

		return $data;
	}

	/**
	 * Function : sort contact
	 * Dev : Poom
	 * Update Date : 17 Apr 2024
	 * @return array data contact info
	 */
	public function sort_contact()
	{
		$data = [];
		$req = ContactInfo::find(1);

		if (!empty($req)) {
			$data['id'] = $req->id;
			if (!empty($config['input']['work']['status']))
				$data['work'] = mwz_getTextString($req->local->work ?? '');
			if (!empty($config['input']['office']['status']))
				$data['office'] = mwz_getTextString($req->local->office ?? '');
			if (!empty($config['input']['email']['status']))
				$data['email'] = $req->email ?? '';
			if (!empty($config['input']['tel']['status']))
				$data['tel'] = $req->tel ?? '';
		}

		return $data;
	}


	// {{-- แค่โปรเจค sew ก็ต้องมีชื่อบริษัทด้วย --}}
	public static function set_title_contact($name)
	{
		// แยกอังกฤษกับไทย
		preg_match('/([A-Za-z0-9.,\s]+)\s+(.*)/u', $name, $matches);
		return [
			'name_en' => $matches[1] ?? '',
			'name_th' => $matches[2] ?? '',
		];
	}
}
