<?php

namespace Modules\Contact\app\Emails;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ContactEmail extends Mailable
{
	use Queueable, SerializesModels;
	public $subject, $data, $setting, $contact, $config;

	public function __construct($subject, $data)
	{
		$this->subject = $subject;
		$this->data = $data;
		$this->setting = setting();
		$this->contact = contact();
		$this->config = config_email();
	}

	public function build(): self
	{
		return $this->subject($this->subject)
			->view('mail.simple', [
				'subject' => $this->subject,
				'data' => $this->data,
				'setting' => $this->setting,
				'contact' => $this->contact,
				'config' => $this->config,
			]);
	}
}
