<?php

use Illuminate\Support\Facades\Route;
use Modules\Banners\app\Http\Controllers\BannerAdminController;
use Modules\Banners\app\Http\Controllers\BannersController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::middleware(['auth:admin', 'adminAccessControl'])->prefix('admin')->name('admin.banner.')->group(function () {
	// ['method', 'url', 'controller', 'name']
	$default_route = [
		['get', '/', 'index', 'index'],
		['get', '/datatable_ajax', 'datatable_ajax', 'datatable_ajax'],
		['get', '/add', 'form', 'add'],
		['get', '/edit/{id?}', 'form', 'edit'],
		['get', '/view/{id?}', 'form', 'view'],
		['post', '/save', 'save', 'save'],
		['post', '/set_sort', 'set_sort', 'set_sort'],
		['post', '/set_re_order', 'set_re_order', 'set_re_order'],
		['post', '/set_status', 'set_status', 'set_status'],
		['post', '/set_delete', 'set_delete', 'set_delete'],
		['post', '/get_menu', 'get_menu', 'get_menu'],
	];

	Route::prefix('banner')->group(function () use ($default_route) {
		Route::prefix('hero')->name('hero.')->group(function () use ($default_route) {
			foreach ($default_route as $route)
				Route::{$route[0]}($route[1], [BannerAdminController::class, $route[2]])->name($route[3]);
		});

		Route::prefix('ads')->name('ads.')->group(function () use ($default_route) {
			foreach ($default_route as $route)
				Route::{$route[0]}($route[1], [BannerAdminController::class, $route[2]])->name($route[3]);
		});
		//contact
		Route::prefix('contact')->name('contact.')->group(function () use ($default_route) {
			foreach ($default_route as $route)
				Route::{$route[0]}($route[1], [BannerAdminController::class, $route[2]])->name($route[3]);
		});

		//news
		Route::prefix('news')->name('news.')->group(function () use ($default_route) {
			foreach ($default_route as $route)
				Route::{$route[0]}($route[1], [BannerAdminController::class, $route[2]])->name($route[3]);
		});

		//about
		Route::prefix('about')->name('about.')->group(function () use ($default_route) {
			foreach ($default_route as $route)
				Route::{$route[0]}($route[1], [BannerAdminController::class, $route[2]])->name($route[3]);
		});

		//course
		Route::prefix('course')->name('course.')->group(function () use ($default_route) {
			foreach ($default_route as $route)
				Route::{$route[0]}($route[1], [BannerAdminController::class, $route[2]])->name($route[3]);
		});

		//research
		Route::prefix('research')->name('research.')->group(function () use ($default_route) {
			foreach ($default_route as $route)
				Route::{$route[0]}($route[1], [BannerAdminController::class, $route[2]])->name($route[3]);
		});

		//department_category
		Route::prefix('department_category')->name('department_category.')->group(function () use ($default_route) {
			foreach ($default_route as $route)
				Route::{$route[0]}($route[1], [BannerAdminController::class, $route[2]])->name($route[3]);
		});

		//department_content
		Route::prefix('department_content')->name('department_content.')->group(function () use ($default_route) {
			foreach ($default_route as $route)
				Route::{$route[0]}($route[1], [BannerAdminController::class, $route[2]])->name($route[3]);
		});
	});
});

Route::middleware(['apiLocale'])->prefix('api/v1')->name('api.')->group(function () {
	Route::prefix('banner')->name('banner.')->group(function () {
		Route::post('/click', [BannersController::class, 'click'])->name('click');
	});
});
