<?php

return [
	'hero' => [
		'table' => [
			'header' => [
				['title' => __('field.image'), 'column' => 'image', 'orderable' => false, 'class' => 'text-center', 'status' => true],
				['title' => __('field.name'), 'column' => 'name', 'orderable' => false, 'class' => '', 'status' => true],
				['title' => __('field.menu_id'), 'column' => 'menu', 'orderable' => false, 'class' => '', 'status' => false],
				['title' => __('field.section'), 'column' => 'section', 'orderable' => false, 'class' => '', 'status' => false],
				['title' => __('field.view'), 'column' => 'view', 'orderable' => false, 'class' => '', 'status' => false],
			],
			'filter' => [
				'menu_id' => ['type' => 'select', 'url' => 'admin.banner.hero.get_menu', 'status' => false],
				'section' => ['type' => 'selection', 'options' => [1 => 'section 1', 2 => 'section 2'], 'status' => false],
			],
			'btn' => [
				'add' => true,
				'sort' => true,
				'status' => true,
				'edit' => true,
				'delete' => true,
			],
		],
		'form' => [
			'navbar' => [
				'translate' => [
					'status' => true,
					'input' => [
						'name' => ['type' => 'input', 'status' => true, 'validate' => true],
						'desc' => ['type' => 'text', 'status' => false, 'validate' => false],
						'detail' => ['type' => 'texteditor', 'status' => false, 'validate' => false],
					],
				],
				'banner' => [
					'status' => true,
					'input' => [
						'row_1' => [
							'status' => true,
							'image' => ['type' => 'upload_image', 'status' => true, 'label' => __('field.image'), 'recommend' => __('field.banner.image_recommend'), 'size' => '','validate' => true],
							'moblie' => ['type' => 'upload_image', 'status' => false, 'label' => __('field.mobile'), 'recommend' => __('field.mobile_recommend'), 'size' => ''],
						],
						'youtube' => ['type' => 'input', 'status' => true,'validate' => true],
						'video' => ['type' => 'upload_video', 'status' => true, 'label' => __('field.video'), 'recommend' => __('field.video_recommend'),'validate' => true],
					]
				]
			],
			'sidebar' => [
				'lang' => [
					'status' => true,
				],
				'setting' => [
					'status' => true,
					'input' => [
						'style' => ['type' => 'selection', 'status' => true, 'validate' => true, 'options' => [1 => __('banners::banner.style.image'), 2 => __('banners::banner.style.youtube'),3 => __('banners::banner.style.video')]],
						'menu_id' => ['type' => 'select', 'status' => false, 'validate' => false, 'url' => 'admin.banner.hero.get_menu'],
						'section' => ['type' => 'selection', 'status' => false, 'validate' => false, 'options' => [1 => 'section 1', 2 => 'section 2']],
						'link' => ['type' => 'input', 'status' => true, 'validate' => false],
						'status' => ['type' => 'checkbox', 'status' => true, 'validate' => false],
					],
				]
			],
		],
		'setting' => [
			're_order' => [
				'status' => false,
			],
			'limit' => [
				'status' => false,
				'max' => 1,
			],
			'limit_menu_id' => [
				'status' => false,
				'limit' => [ // key = id, value = max
					// 2 => 1,
				],
			],
			'limit_section' => [
				'status' => false,
				'limit' => [ // key = index, value = max
					// 1 => 1,
				],
			],
		]
	],

	'ads' => [
		'table' => [
			'header' => [
				['title' => __('field.image'), 'column' => 'image', 'orderable' => false, 'class' => 'text-center', 'status' => true],
				['title' => __('field.name'), 'column' => 'name', 'orderable' => false, 'class' => '', 'status' => true],
				['title' => __('field.menu_id'), 'column' => 'menu', 'orderable' => false, 'class' => '', 'status' => false],
				['title' => __('field.section'), 'column' => 'section', 'orderable' => false, 'class' => '', 'status' => false],
				['title' => __('field.view'), 'column' => 'view', 'orderable' => false, 'class' => '', 'status' => true],
			],
			'filter' => [
				'menu_id' => ['type' => 'select', 'url' => 'admin.banner.hero.get_menu', 'status' => false],
				'section' => ['type' => 'selection', 'options' => [1 => 'section 1', 2 => 'section 2'], 'status' => false],
			],
			'btn' => [
				'add' => true,
				'sort' => true,
				'status' => true,
				'edit' => true,
				'delete' => true,
			],
		],
		'form' => [
			'navbar' => [
				'translate' => [
					'status' => true,
					'input' => [
						'name' => ['type' => 'input', 'status' => true, 'validate' => true],
						'desc' => ['type' => 'text', 'status' => false, 'validate' => false],
						'detail' => ['type' => 'texteditor', 'status' => false, 'validate' => false],
					],
				],
				'banner' => [
					'status' => true,
					'input' => [
						'row_1' => [
							'status' => true,
							'image' => ['type' => 'upload_image', 'status' => true, 'label' => __('field.image'), 'recommend' => __('field.image_recommend'), 'size' => ''],
							'moblie' => ['type' => 'upload_image', 'status' => false, 'label' => __('field.mobile'), 'recommend' => __('field.mobile_recommend'), 'size' => ''],
						],
						'youtube' => ['type' => 'input', 'status' => false],
						'video' => ['type' => 'upload_video', 'status' => false, 'label' => __('field.video'), 'recommend' => __('field.video_recommend')],
					]
				]
			],
			'sidebar' => [
				'lang' => [
					'status' => true,
				],
				'setting' => [
					'status' => true,
					'input' => [
						'style' => ['type' => 'selection', 'status' => true, 'validate' => true, 'options' => [1 => __('banners::banner.style.image')]],
						'menu_id' => ['type' => 'select', 'status' => false, 'validate' => false, 'url' => 'admin.banner.hero.get_menu'],
						'section' => ['type' => 'selection', 'status' => false, 'validate' => false, 'options' => [1 => 'section 1', 2 => 'section 2']],
						'link' => ['type' => 'input', 'status' => true, 'validate' => false],
						'status' => ['type' => 'checkbox', 'status' => true, 'validate' => false],
					],
				]
			],
		],
		'setting' => [
			're_order' => [
				'status' => false,
			],
			'limit' => [
				'status' => false,
				'max' => 1,
			],
			'limit_menu_id' => [
				'status' => false,
				'limit' => [ // key = id, value = max
					// 2 => 1,
				],
			],
			'limit_section' => [
				'status' => false,
				'limit' => [ // key = index, value = max
					// 1 => 1,
				],
			],
		]
	],
];